#!/usr/bin/perl

# ADMIN_update_server_ip.pl - updates IP address in DB and conf file
#
# This script is designed to update all database tables and the local 
# astguiclient.conf file to reflect a change in IP address. The script will 
# automatically default to the first eth address in the ifconfig output.
#
# Copyright (C) 2024  Matt Florell <vicidial@gmail.com>    LICENSE: AGPLv2
#
# CHANGELOG
# 71205-2144 - Added display of extensions.conf example for call routing
# 80321-0220 - Updated for new settings
# 90211-1247 - Added asterisk version
# 90630-2256 - vicidial_process_triggers
# 100428-0943 - Added DB custom user/pass fields
# 150312-1000 - Added ExpectedDBSchema
# 180928-1958 - Added update of report_server, active_twin_server_ip and active_voicemail_server, issue #1109
# 190530-1517 - Added mising commented-out keepalives in conf file
# 240420-2247 - Added ConfBridge code
# 240704-1737 - Added CS server variables
#

# default path to astguiclient configuration file:
$PATHconf =		'/etc/astguiclient.conf';

open(conf, "$PATHconf") || die "can't open $PATHconf: $!\n";
@conf = <conf>;
close(conf);
$i=0;
foreach(@conf)
	{
	$line = $conf[$i];
	$line =~ s/ |>|\n|\r|\t|\#.*|;.*//gi;
	if ( ($line =~ /^VARserver_ip/) && ($CLIserver_ip < 1) )
		{$VARold_server_ip = $line;   $VARold_server_ip =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_server/) && ($CLIDB_server < 1) )
		{$VARDB_server = $line;   $VARDB_server =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_database/) && ($CLIDB_database < 1) )
		{$VARDB_database = $line;   $VARDB_database =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_user/) && ($CLIDB_user < 1) )
		{$VARDB_user = $line;   $VARDB_user =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_pass/) && ($CLIDB_pass < 1) )
		{$VARDB_pass = $line;   $VARDB_pass =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_port/) && ($CLIDB_port < 1) )
		{$VARDB_port = $line;   $VARDB_port =~ s/.*=//gi;}
	if ( ($line =~ /^VARCS_server/) && ($CLICS_server < 1) )
		{$VARCS_server = $line;   $VARCS_server =~ s/.*=//gi;}
	if ( ($line =~ /^VARCS_database/) && ($CLICS_database < 1) )
		{$VARCS_database = $line;   $VARCS_database =~ s/.*=//gi;}
	if ( ($line =~ /^VARCS_user/) && ($CLICS_user < 1) )
		{$VARCS_user = $line;   $VARCS_user =~ s/.*=//gi;}
	if ( ($line =~ /^VARCS_pass/) && ($CLICS_pass < 1) )
		{$VARCS_pass = $line;   $VARCS_pass =~ s/.*=//gi;}
	if ( ($line =~ /^VARCS_port/) && ($CLICS_port < 1) )
		{$VARCS_port = $line;   $VARCS_port =~ s/.*=//gi;}
	$i++;
	}

############################################

$CLIold_server_ip=0;
$CLIserver_ip=0;

$secX = time();

# constants
$DB=1;  # Debug flag, set to 0 for no debug messages, lots of output
$US='_';
$MT[0]='';

### begin parsing run-time options ###
if (length($ARGV[0])>1)
	{
	$i=0;
	while ($#ARGV >= $i)
		{
		$args = "$args $ARGV[$i]";
		$i++;
		}

	if ($args =~ /--help/i)
		{
		print "ADMIN_update_server_ip.pl - updates server_ip in the $VARDB_database\n";
		print "database and in the local /etc/astguiclient.conf file.\n";
		print "\n";
		print "command-line options:\n";
		print "  [--help] = this help screen\n";
		print "  [--debug] = verbose debug messages\n";
		print "  [--auto] = no prompts\n";
		print "configuration options:\n";
		print "  [--old-server_ip=192.168.0.1] = define old server IP address at runtime\n";
		print "  [--server_ip=192.168.0.2] = define new server IP address at runtime\n";
		print "\n";

		exit;
		}
	else
		{
		if ($args =~ /--debug/i) # Debug flag
			{
			$DB=1;
			}
		if ($args =~ /--auto/i) # no prompts flag
			{
			$AUTO=1;
			}
		if ($args =~ /--old-server_ip=/i) # CLI defined old server IP address
			{
			@CLIoldserver_ipARY = split(/--old-server_ip=/,$args);
			@CLIoldserver_ipARX = split(/ /,$CLIoldserver_ipARY[1]);
			if (length($CLIoldserver_ipARX[0])>2)
				{
				$VARold_server_ip = $CLIoldserver_ipARX[0];
				$VARold_server_ip =~ s/\/$| |\r|\n|\t//gi;
				$CLIold_server_ip=1;
				print "  CLI defined old server IP:  $VARold_server_ip\n";
				}
			}
		if ($args =~ /--server_ip=/i) # CLI defined server IP address
			{
			@CLIserver_ipARY = split(/--server_ip=/,$args);
			@CLIserver_ipARX = split(/ /,$CLIserver_ipARY[1]);
			if (length($CLIserver_ipARX[0])>2)
				{
				$VARserver_ip = $CLIserver_ipARX[0];
				$VARserver_ip =~ s/\/$| |\r|\n|\t//gi;
				$CLIserver_ip=1;
				print "  CLI defined server IP:      $VARserver_ip\n";
				}
			}
		}
	}
else
	{
	#	print "no command line options set\n";
	}
### end parsing run-time options ###

if (-e "$PATHconf") 
	{
	print "Previous astGUIclient configuration file found at: $PATHconf\n";
	open(conf, "$PATHconf") || die "can't open $PATHconf: $!\n";
	@conf = <conf>;
	close(conf);
	$i=0;
	foreach(@conf)
		{
		$line = $conf[$i];
		$line =~ s/ |>|\n|\r|\t|\#.*|;.*//gi;
		if ( ($line =~ /^PATHhome/) && ($CLIhome < 1) )
			{$PATHhome = $line;   $PATHhome =~ s/.*=//gi;}
		if ( ($line =~ /^PATHlogs/) && ($CLIlogs < 1) )
			{$PATHlogs = $line;   $PATHlogs =~ s/.*=//gi;}
		if ( ($line =~ /^PATHagi/) && ($CLIagi < 1) )
			{$PATHagi = $line;   $PATHagi =~ s/.*=//gi;}
		if ( ($line =~ /^PATHweb/) && ($CLIweb < 1) )
			{$PATHweb = $line;   $PATHweb =~ s/.*=//gi;}
		if ( ($line =~ /^PATHsounds/) && ($CLIsounds < 1) )
			{$PATHsounds = $line;   $PATHsounds =~ s/.*=//gi;}
		if ( ($line =~ /^PATHmonitor/) && ($CLImonitor < 1) )
			{$PATHmonitor = $line;   $PATHmonitor =~ s/.*=//gi;}
		if ( ($line =~ /^PATHDONEmonitor/) && ($CLIDONEmonitor < 1) )
			{$PATHDONEmonitor = $line;   $PATHDONEmonitor =~ s/.*=//gi;}
#		if ( ($line =~ /^VARserver_ip/) && ($CLIserver_ip < 1) )
#			{$VARserver_ip = $line;   $VARserver_ip =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_server/) && ($CLIDB_server < 1) )
			{$VARDB_server = $line;   $VARDB_server =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_database/) && ($CLIDB_database < 1) )
			{$VARDB_database = $line;   $VARDB_database =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_user/) && ($CLIDB_user < 1) )
			{$VARDB_user = $line;   $VARDB_user =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_pass/) && ($CLIDB_pass < 1) )
			{$VARDB_pass = $line;   $VARDB_pass =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_custom_user/) && ($CLIDB_custom_user < 1) )
			{$VARDB_custom_user = $line;   $VARDB_custom_user =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_custom_pass/) && ($CLIDB_custom_pass < 1) )
			{$VARDB_custom_pass = $line;   $VARDB_custom_pass =~ s/.*=//gi;}
		if ( ($line =~ /^VARDB_port/) && ($CLIDB_port < 1) )
			{$VARDB_port = $line;   $VARDB_port =~ s/.*=//gi;}
		if ( ($line =~ /^VARCS_server/) && ($CLICS_server < 1) )
			{$VARCS_server = $line;   $VARCS_server =~ s/.*=//gi;}
		if ( ($line =~ /^VARCS_database/) && ($CLICS_database < 1) )
			{$VARCS_database = $line;   $VARCS_database =~ s/.*=//gi;}
		if ( ($line =~ /^VARCS_user/) && ($CLICS_user < 1) )
			{$VARCS_user = $line;   $VARCS_user =~ s/.*=//gi;}
		if ( ($line =~ /^VARCS_pass/) && ($CLICS_pass < 1) )
			{$VARCS_pass = $line;   $VARCS_pass =~ s/.*=//gi;}
		if ( ($line =~ /^VARCS_port/) && ($CLICS_port < 1) )
			{$VARCS_port = $line;   $VARCS_port =~ s/.*=//gi;}
		if ( ($line =~ /^VARactive_keepalives/) && ($CLIactive_keepalives < 1) )
			{$VARactive_keepalives = $line;   $VARactive_keepalives =~ s/.*=//gi;}
		if ( ($line =~ /^VARasterisk_version/) && ($CLIasterisk_version < 1) )
			{$VARasterisk_version = $line;   $VARasterisk_version =~ s/.*=//gi;}
		if ( ($line =~ /^VARFTP_host/) && ($CLIFTP_host < 1) )
			{$VARFTP_host = $line;   $VARFTP_host =~ s/.*=//gi;}
		if ( ($line =~ /^VARFTP_user/) && ($CLIFTP_user < 1) )
			{$VARFTP_user = $line;   $VARFTP_user =~ s/.*=//gi;}
		if ( ($line =~ /^VARFTP_pass/) && ($CLIFTP_pass < 1) )
			{$VARFTP_pass = $line;   $VARFTP_pass =~ s/.*=//gi;}
		if ( ($line =~ /^VARFTP_port/) && ($CLIFTP_port < 1) )
			{$VARFTP_port = $line;   $VARFTP_port =~ s/.*=//gi;}
		if ( ($line =~ /^VARFTP_dir/) && ($CLIFTP_dir < 1) )
			{$VARFTP_dir = $line;   $VARFTP_dir =~ s/.*=//gi;}
		if ( ($line =~ /^VARHTTP_path/) && ($CLIHTTP_path < 1) )
			{$VARHTTP_path = $line;   $VARHTTP_path =~ s/.*=//gi;}
		if ( ($line =~ /^VARREPORT_host/) && ($CLIREPORT_host < 1) )
			{$VARREPORT_host = $line;   $VARREPORT_host =~ s/.*=//gi;}
		if ( ($line =~ /^VARREPORT_user/) && ($CLIREPORT_user < 1) )
			{$VARREPORT_user = $line;   $VARREPORT_user =~ s/.*=//gi;}
		if ( ($line =~ /^VARREPORT_pass/) && ($CLIREPORT_pass < 1) )
			{$VARREPORT_pass = $line;   $VARREPORT_pass =~ s/.*=//gi;}
		if ( ($line =~ /^VARREPORT_port/) && ($CLIREPORT_port < 1) )
			{$VARREPORT_port = $line;   $VARREPORT_port =~ s/.*=//gi;}
		if ( ($line =~ /^VARREPORT_dir/) && ($CLIREPORT_dir < 1) )
			{$VARREPORT_dir = $line;   $VARREPORT_dir =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_min_servers/) && ($CLIVARfastagi_log_min_servers < 1) )
			{$VARfastagi_log_min_servers = $line;   $VARfastagi_log_min_servers =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_max_servers/) && ($CLIVARfastagi_log_max_servers < 1) )
			{$VARfastagi_log_max_servers = $line;   $VARfastagi_log_max_servers =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_min_spare_servers/) && ($CLIVARfastagi_log_min_spare_servers < 1) )
			{$VARfastagi_log_min_spare_servers = $line;   $VARfastagi_log_min_spare_servers =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_max_spare_servers/) && ($CLIVARfastagi_log_max_spare_servers < 1) )
			{$VARfastagi_log_max_spare_servers = $line;   $VARfastagi_log_max_spare_servers =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_max_requests/) && ($CLIVARfastagi_log_max_requests < 1) )
			{$VARfastagi_log_max_requests = $line;   $VARfastagi_log_max_requests =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_checkfordead/) && ($CLIVARfastagi_log_checkfordead < 1) )
			{$VARfastagi_log_checkfordead = $line;   $VARfastagi_log_checkfordead =~ s/.*=//gi;}
		if ( ($line =~ /^VARfastagi_log_checkforwait/) && ($CLIVARfastagi_log_checkforwait < 1) )
			{$VARfastagi_log_checkforwait = $line;   $VARfastagi_log_checkforwait =~ s/.*=//gi;}
		if ($line =~ /^ExpectedDBSchema/)
			{$ExpectedDBSchema = $line;   $ExpectedDBSchema =~ s/.*=//gi;}
		$i++;
		}
	}

if ($AUTO)
	{
	$manual='n';
	if (length($VARserver_ip)<7)
		{	
		@ip = `/sbin/ifconfig`;
		$j=0;
		while($#ip>=$j)
			{
			if ($ip[$j] =~ /inet addr/) {$VARserver_ip = $ip[$j]; $j=1000;}
			$j++;
			}
		$VARserver_ip =~ s/.*addr:| Bcast.*|\r|\n|\t| //gi;
		}
	}
else
	{
	print("\nWould you like to use interactive mode (y/n): [y] ");
	$manual = <STDIN>;
	chomp($manual);
	}

if ($manual =~ /n/i)
	{
	$manual=0;
	}
else
	{
	$config_finished='NO';
	while ($config_finished =~/NO/)
		{
		print "\nSTARTING SERVER IP ADDRESS CHANGE FOR VICIDIAL...\n";

		##### BEGIN old_server_ip propmting and check #####
		$continue='NO';
		while ($continue =~/NO/)
			{
			print("\nOld server IP address or press enter for default: [$VARold_server_ip] ");
			$PROMPTold_server_ip = <STDIN>;
			chomp($PROMPTold_server_ip);
			if (length($PROMPTold_server_ip)>6)
				{
				$PROMPTold_server_ip =~ s/ |\n|\r|\t|\/$//gi;
				$VARold_server_ip=$PROMPTold_server_ip;
				$continue='YES';
				}
			else
				{
				$continue='YES';
				}
			}
		##### END old_server_ip propmting and check  #####

		##### BEGIN server_ip propmting and check #####
		if (length($VARserver_ip)<7)
			{	
			### get best guess of IP address from ifconfig output ###
			# inet addr:10.10.11.17  Bcast:10.10.255.255  Mask:255.255.0.0
			@ip = `/sbin/ifconfig`;
			$j=0;
			while($#ip>=$j)
				{
				if ($ip[$j] =~ /inet addr/) {$VARserver_ip = $ip[$j]; $j=1000;}
				$j++;
				}
			$VARserver_ip =~ s/.*addr:| Bcast.*|\r|\n|\t| //gi;
			}

		$continue='NO';
		while ($continue =~/NO/)
			{
			print("\nserver IP address or press enter for default: [$VARserver_ip] ");
			$PROMPTserver_ip = <STDIN>;
			chomp($PROMPTserver_ip);
			if (length($PROMPTserver_ip)>6)
				{
				$PROMPTserver_ip =~ s/ |\n|\r|\t|\/$//gi;
				$VARserver_ip=$PROMPTserver_ip;
				$continue='YES';
				}
			else
				{
				$continue='YES';
				}
			}
		##### END server_ip propmting and check  #####



		print "\n";
		print "  old server_ip:      $VARold_server_ip\n";
		print "  new server_ip:      $VARserver_ip\n";
		print "\n";

		print("Are these settings correct?(y/n): [y] ");
		$PROMPTconfig = <STDIN>;
		chomp($PROMPTconfig);
		if ( (length($PROMPTconfig)<1) or ($PROMPTconfig =~ /y/i) )
			{
			$config_finished='YES';
			}
		}
	}

print "Writing change to astguiclient.conf file: $PATHconf\n";

open(conf, ">$PATHconf") || die "can't open $PATHconf: $!\n";
print conf "# astguiclient.conf - configuration elements for the astguiclient package\n";
print conf "# this is the astguiclient configuration file \n";
print conf "# all comments will be lost if you run install.pl again\n";
print conf "\n";
print conf "# Paths used by astGUIclient\n";
print conf "PATHhome => $PATHhome\n";
print conf "PATHlogs => $PATHlogs\n";
print conf "PATHagi => $PATHagi\n";
print conf "PATHweb => $PATHweb\n";
print conf "PATHsounds => $PATHsounds\n";
print conf "PATHmonitor => $PATHmonitor\n";
print conf "PATHDONEmonitor => $PATHDONEmonitor\n";
print conf "\n";
print conf "# The IP address of this machine\n";
print conf "VARserver_ip => $VARserver_ip\n";
print conf "\n";
print conf "# Database connection information\n";
print conf "VARDB_server => $VARDB_server\n";
print conf "VARDB_database => $VARDB_database\n";
print conf "VARDB_user => $VARDB_user\n";
print conf "VARDB_pass => $VARDB_pass\n";
print conf "VARDB_custom_user => $VARDB_custom_user\n";
print conf "VARDB_custom_pass => $VARDB_custom_pass\n";
print conf "VARDB_port => $VARDB_port\n";
print conf "VARCS_server => $VARCS_server\n";
print conf "VARCS_database => $VARCS_database\n";
print conf "VARCS_user => $VARCS_user\n";
print conf "VARCS_pass => $VARCS_pass\n";
print conf "VARCS_port => $VARCS_port\n";
print conf "\n";
print conf "# Alpha-Numeric list of the astGUIclient processes to be kept running\n";
print conf "# (value should be listing of characters with no spaces: 123456)\n";
print conf "#  X - NO KEEPALIVE PROCESSES (use only if you want none to be keepalive)\n";
print conf "#  1 - AST_update\n";
print conf "#  2 - AST_send_listen\n";
print conf "#  3 - AST_VDauto_dial\n";
print conf "#  4 - AST_VDremote_agents\n";
print conf "#  5 - AST_VDadapt (If multi-server system, this must only be on one server)\n";
print conf "#  6 - FastAGI_log\n";
print conf "#  7 - AST_VDauto_dial_FILL (only for multi-server, this must only be on one server)\n";
print conf "#  8 - ip_relay (used for blind agent monitoring)\n";
print conf "#  9 - Timeclock auto logout\n";
print conf "#  E - Email processor, (If multi-server system, this must only be on one server)\n";
print conf "#  S - SIP Logger (Patched Asterisk 13 required)\n";
print conf "VARactive_keepalives => $VARactive_keepalives\n";
print conf "\n";
print conf "# Asterisk version VICIDIAL is installed for\n";
print conf "VARasterisk_version => $VARasterisk_version\n";
print conf "\n";
print conf "# FTP recording archive connection information\n";
print conf "VARFTP_host => $VARFTP_host\n";
print conf "VARFTP_user => $VARFTP_user\n";
print conf "VARFTP_pass => $VARFTP_pass\n";
print conf "VARFTP_port => $VARFTP_port\n";
print conf "VARFTP_dir => $VARFTP_dir\n";
print conf "VARHTTP_path => $VARHTTP_path\n";
print conf "\n";
print conf "# REPORT server connection information\n";
print conf "VARREPORT_host => $VARREPORT_host\n";
print conf "VARREPORT_user => $VARREPORT_user\n";
print conf "VARREPORT_pass => $VARREPORT_pass\n";
print conf "VARREPORT_port => $VARREPORT_port\n";
print conf "VARREPORT_dir => $VARREPORT_dir\n";
print conf "\n";
print conf "# Settings for FastAGI logging server\n";
print conf "VARfastagi_log_min_servers => $VARfastagi_log_min_servers\n";
print conf "VARfastagi_log_max_servers => $VARfastagi_log_max_servers\n";
print conf "VARfastagi_log_min_spare_servers => $VARfastagi_log_min_spare_servers\n";
print conf "VARfastagi_log_max_spare_servers => $VARfastagi_log_max_spare_servers\n";
print conf "VARfastagi_log_max_requests => $VARfastagi_log_max_requests\n";
print conf "VARfastagi_log_checkfordead => $VARfastagi_log_checkfordead\n";
print conf "VARfastagi_log_checkforwait => $VARfastagi_log_checkforwait\n";
print conf "\n";
print conf "# Expected DB Schema version for this install\n";
print conf "ExpectedDBSchema => $ExpectedDBSchema\n";
close(conf);


print "\nSTARTING DATABASE TABLES UPDATES PHASE...\n";

if (!$VARDB_port) {$VARDB_port='3306';}

use DBI;
$dbhA = DBI->connect("DBI:mysql:$VARDB_database:$VARDB_server:$VARDB_port", "$VARDB_user", "$VARDB_pass")
	or die "Couldn't connect to database: " . DBI->errstr;

print "  Updating servers table: server_ip...\n";
$stmtA = "UPDATE servers SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating servers table: active_twin_server_ip...\n";
$stmtA = "UPDATE servers SET active_twin_server_ip='$VARserver_ip' where active_twin_server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating system_settings table: active_voicemail_server...\n";
$stmtA = "UPDATE system_settings SET active_voicemail_server='$VARserver_ip' where active_voicemail_server='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_automated_reports table: report_server...\n";
$stmtA = "UPDATE vicidial_automated_reports SET report_server='$VARserver_ip' where report_server='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating phones table...\n";
$stmtA = "UPDATE phones SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating inbound_numbers table...\n";
$stmtA = "UPDATE inbound_numbers SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating server_updater table...\n";
$stmtA = "UPDATE server_updater SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating conferences table...\n";
$stmtA = "UPDATE conferences SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_conferences table...\n";
$stmtA = "UPDATE vicidial_conferences SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_confbridges table...\n";
$stmtA = "UPDATE vicidial_confbridges SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_stations table...\n";
$stmtA = "UPDATE vicidial_stations SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_remote_agents table...\n";
$stmtA = "UPDATE vicidial_remote_agents SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating phone_favorites table...\n";
$stmtA = "UPDATE phone_favorites SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_server_trunks table...\n";
$stmtA = "UPDATE vicidial_server_trunks SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_server_carriers table...\n";
$stmtA = "UPDATE vicidial_server_carriers SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_inbound_dids table: server_ip...\n";
$stmtA = "UPDATE vicidial_inbound_dids SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_inbound_dids table: filter_server_ip...\n";
$stmtA = "UPDATE vicidial_inbound_dids SET filter_server_ip='$VARserver_ip' where filter_server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Updating vicidial_process_triggers table...\n";
$stmtA = "UPDATE vicidial_process_triggers SET server_ip='$VARserver_ip' where server_ip='$VARold_server_ip';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}

print "  Setting servers to rebuild conf files...\n";
$stmtA="UPDATE servers SET rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y';";
$affected_rows = $dbhA->do($stmtA);
if ($DB) {print "     |$affected_rows|$stmtA|\n";}


$dbhA->disconnect();

### format the new server_ip dialstring for example to use with extensions.conf
$S='*';
if( $VARserver_ip =~ m/(\S+)\.(\S+)\.(\S+)\.(\S+)/ )
	{
	$a = leading_zero($1); 
	$b = leading_zero($2); 
	$c = leading_zero($3); 
	$d = leading_zero($4);
	$VARremDIALstr = "$a$S$b$S$c$S$d";
	}

print "\n";
print "SERVER IP ADDRESS CHANGE FOR VICIDIAL FINISHED!\n";
print "\n";


$secy = time();		$secz = ($secy - $secX);		$minz = ($secz/60);		# calculate script runtime so far
print "\n     - process runtime      ($secz sec) ($minz minutes)\n";


exit;


sub leading_zero($) 
	{
    $_ = $_[0];
    s/^(\d)$/0$1/;
    s/^(\d\d)$/0$1/;
    return $_;
	} # End of the leading_zero() routine.
