#!/usr/bin/perl
#
# VDAD_file_clean.pl version 0.1
# 
# Clears out the answered call files and the empty -in files
#
# Copyright (C) 2006  Matt Florell <vicidial@gmail.com>    LICENSE: GPLv2
#

$V = 1;		# set to 1 for verbose mode
$M = 1;		# set to 1 for 2 line messages mode

### Make sure this file is in a path or put the absolute path to it
require("/home/cron/AST_SERVER_conf.pl");	# local configuration file

use Time::HiRes ('gettimeofday','usleep','sleep');  # necessary to have perl sleep command of less than one second
use Net::MySQL;
#use Net::FTP;


### remove all of the -in files before getting file list
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................0-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................1-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................2-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................3-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................4-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................5-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................6-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................7-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................8-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V..................9-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................0-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................1-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................2-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................3-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................4-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................5-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................6-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................7-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................8-in.gsm`;
`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/V...................9-in.gsm`;

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year = ($year + 1900);
$mon++;
if ($mon < 10) {$mon = "0$mon";}
if ($mday < 10) {$mday = "0$mday";}
if ($hour < 10) {$Fhour = "0$hour";}
if ($min < 10) {$min = "0$min";}
if ($sec < 10) {$sec = "0$sec";}

$now_date_epoch = time();
$now_date = "$year-$mon-$mday $hour:$min:$sec";
$start_time=$now_date;
	$CIDdate = "$mon$mday$hour$min$sec";
	$tsSQLdate = "$year$mon$mday$hour$min$sec";
	$SQLdate = "$year-$mon-$mday $hour:$min:$sec";

$BDtarget = ($secX - 86400);
($Bsec,$Bmin,$Bhour,$Bmday,$Bmon,$Byear,$Bwday,$Byday,$Bisdst) = localtime($BDtarget);
$Byear = ($Byear + 1900);
$Bmon++;
if ($Bmon < 10) {$Bmon = "0$Bmon";}
if ($Bmday < 10) {$Bmday = "0$Bmday";}
if ($Bhour < 10) {$Bhour = "0$Bhour";}
if ($Bmin < 10) {$Bmin = "0$Bmin";}
if ($Bsec < 10) {$Bsec = "0$Bsec";}
	$BDtsSQLdate = "$Byear$Bmon$Bmday$Bhour$Bmin$Bsec";



### begin parsing run-time options ###
if (length($ARGV[0])>1)
{
if ($DB) {print STDERR "Perl Environment Dump:\n";}
	$i=0;
	while ($#ARGV >= $i)
	{
	$args = "$args $ARGV[$i]";
	if ($DB) {print STDERR "$i|$ARGV[$i]|\n";}
	$i++;
	}

	if ($args =~ /--help/i)
	{
	print "allowed run time options:\n  [-q] = quiet\n  [-t] = test\n  [-debug] = verbose debug messages\n\n";
	}
	else
	{
		if ($args =~ /-V/i)
		{
		$V=1;
		}
		if ($args =~ /-debug/i)
		{
		$DB=1;
		}
		if ($args =~ /-dbAVS/i)
		{
		$DGA=1;
		}
		if ($args =~ /-q/i)
		{
		$q=1;
		$Q=1;
		}
		if ($args =~ /-t/i)
		{
		$TEST=1;
		$T=1;
		}
	}
}
else
{
if ($V) {print "no command line options set\n";}
}

if (!$DB_port) {$DB_port='3306';}

my $dbhA = Net::MySQL->new(hostname => "$DB_server", database => "$DB_database", user => "$DB_user", password => "$DB_pass", port => "$DB_port") 
or 	die "Couldn't connect to database:  $DB_server - $DB_database\n";


$dir1 = '/var/spool/asterisk/monitor/ORIG/VDAD';

if ($DB) {print "Waiting 20 seconds before we begin\n";}
sleep(20);
if ($DB) {print "Starting soundfile processing...\n";}

#$ftp = Net::FTP->new("10.10.12.3", Port => 21, Debug=> 1);
#$ftp->login("cron",'tofumer1');
#$ftp->cwd("RECORDINGS");
#$ftp->cwd("GSM");
#$ftp->cwd("VDAD");
#$ftp->binary();

 opendir(FILE, "$dir1/");
 @FILES = readdir(FILE);

foreach(@FILES)
   {
	$size1 = 0;
	$size2 = 0;
	$person_id_delete = '';
	$transaction_id_delete = '';

	if (length($FILES[$i]) > 20)
		{
		$size1 = (-s "$dir1/$FILES[$i]");
		if (!$q) {print "$FILES[$i] $size1\n";}
	#	usleep(1*30*1000);	# sleep for thirtieth of a second
		$size2 = (-s "$dir1/$FILES[$i]");
		if (!$q) {print "$FILES[$i] $size2\n\n";}

		if ( ($FILES[$i] !~ /^TRANSFERRED/i) && ($size1 eq $size2) && ($FILES[$i] =~ /^V/))
			{
			$status = '';
			$lead_id = $FILES[$i];
			$lead_id =~ s/-out.gsm|V\d\d\d\d\d\d\d\d\d\d//gi;
			$lead_id = ($lead_id + 0);
			if ($DB) {print "analyzing file: $lead_id   $FILES[$i]";}

			$dbhA->query("SELECT status from vicidial_list where lead_id='$lead_id'");
			if ($dbhA->has_selected_record)
			   {
				$iter=$dbhA->create_record_iterator;
				$rec_count=0;
				while ( $record = $iter->each)
					{
					$status =		 "$record->[0]";
					}
			   }
			if ( ($status =~ /NA/) && ($FILES[$i] !~ /in/) )
				{
				if ($DB) {print "     file is NA: $lead_id MOVING...";}
				`/bin/mv -f /var/spool/asterisk/monitor/ORIG/VDAD/$FILES[$i] /var/spool/asterisk/monitor/ORIG/VDAD/GO/`;

	#			$ftp->put("$dir1/$FILES[$i]", "$FILES[$i]");
				}
			else
				{
				if ($DB) {print "     file is not NA: $lead_id DELETING";}
				`/bin/rm -f /var/spool/asterisk/monitor/ORIG/VDAD/$FILES[$i]`;
				}

			}
		}

	if ( ($i =~ /0$/i) && ($DB) ) {print ".";}
	if ( ($i =~ /00$/i) && ($DB) ){print "$i\n";}

	$i++;
   }

#$ftp->quit;

exit;
