#!/usr/bin/perl

#
# Copyright (C) 2006  Matt Florell <vicidial@gmail.com>    LICENSE: GPLv2
#

$MT[0]='';

$secX = time();

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year = ($year + 1900);
$mon++;
if ($mon < 10) {$mon = "0$mon";}
if ($mday < 10) {$mday = "0$mday";}
$pulldate0 = "$year/$mon/$mday";
$inSD = $pulldate0;

print "\n\n\n\n\n\n\n\n\n\n\n\n-- VDAD_IN_response_sphinx.pl --\n\n";
print "This program is designed to analyze the results.txt file generated by sphinx to determine the dispositions of NAs from vicidial recordings\n";

### begin parsing run-time options ###
if (length($ARGV[0])>1)
{
	$i=0;
	while ($#ARGV >= $i)
	{
	$args = "$args $ARGV[$i]";
	$i++;
	}

	if ($args =~ /--help/i)
	{
	print "allowed run time options:\n  [-q] = quiet\n  [-t] = test\n\n";
	}
	else
	{
		if ($args =~ /-q/i)
		{
		$q=1;
		}
		if ($args =~ /--debug/i)
		{
		$DB=1;
		}
		if ($args =~ /-t/i)
		{
		$T=1;
		print "\n-----TESTING -----\n\n";
		}
	}
}
else
{
print "no command line options set\n";
}
### end parsing run-time options ###


$suf = '.txt';
$people_packages_id_update='';
$dir1 = '/home/cron/RESULTS';
$dir2 = "$dir1/DONE";
$dir3 = '/var/spool/asterisk/monitor/ORIG/VDAD/GO/USA';

use Net::MySQL;

### Make sure this file is in a libs path or put the absolute path to it
require("/home/cron/AST_SERVER_conf.pl");	# local configuration file

if (!$DB_port) {$DB_port='3306';}

my $dbhA = Net::MySQL->new(hostname => "$DB_server", database => "$DB_database", user => "$DB_user", password => "$DB_pass", port => "$DB_port") 
	or 	die "Couldn't connect to database: $DB_server - $DB_database\n";


 opendir(FILE, "$dir1/");
 @FILES = readdir(FILE);


foreach(@FILES)
   {
	$size1 = 0;
	$size2 = 0;
	$person_id_delete = '';
	$transaction_id_delete = '';

	if (length($FILES[$i]) > 4)
		{

		$size1 = (-s "$dir1/$FILES[$i]");
		if (!$q) {print "$FILES[$i] $size1\n";}
		sleep(2);
		$size2 = (-s "$dir1/$FILES[$i]");
		if (!$q) {print "$FILES[$i] $size2\n\n";}


		if ( ($FILES[$i] !~ /^TRANSFERRED/i) && ($size1 eq $size2) && (length($FILES[$i]) > 4))
			{
			$GOODfname = $FILES[$i];
			$FILES[$i] =~ s/ /_/gi;
			$FILES[$i] =~ s/\(|\)|\||\\|\/|\'|\"|//gi;
			rename("$dir1/$GOODfname","$dir1/$FILES[$i]");
			$FILEname = $FILES[$i];

			$Routfile = "ERR_$source$FILES[$i]";
			$Loutfile = "LOG_$source$FILES[$i]";
			$Toutfile = "SQL_$source$FILES[$i]";
			$Doutfile = "DCN_$source$FILES[$i]";

	print "Response File: $dir2/$source$FILES[$i]\n";

	### open the in file for reading ###
	open(infile, "$dir1/$source$FILES[$i]")
			|| die "Can't open $source$FILES[$i]: $!\n";

	### open the error out file for writing ###
	open(Rout, ">>$dir2/$Routfile")
			|| die "Can't open $Routfile: $!\n";

	### open the error out file for writing ###
	open(Lout, ">>$dir2/$Loutfile")
			|| die "Can't open $Loutfile: $!\n";

	### open the error out file for writing ###
	open(Tout, ">>$dir2/$Toutfile")
			|| die "Can't open $Toutfile: $!\n";

	### open the error out file for writing ###
	open(Dout, ">>$dir2/$Doutfile")
			|| die "Can't open $Doutfile: $!\n";




	print "\n\n SQL inserts will be put in $Toutfile\n\n";

	$wav = '.wav';

# A  (V0804164122000892434-out  -509148510)


	while (<infile>)
	{
	@m = @MT;	@fn = @MT;	@fnx = @MT;

	$number = $_;
	$raw = $number;
	chomp($number);
	$filename = $number;
	$number =~ s/ \(.*$//gi;
	@m = split(/ /, $number);
		$word_count = "$#m";
	@fn = split(/\(/, $filename);
		@fnx = split(/ /, $fn[1]);
		$Xfilename="$fnx[0]";
			$lead_id = '';
			$lead_id = $Xfilename;
			if (length($lead_id) == 24) {$lead_id =~ s/-out.*$|V\d\d\d\d\d\d\d\d\d\d//gi;}
			  else {$lead_id =~ s/-out.*$|V\d\d\d\d\d\d\d\d\d//gi;}
			$lead_idZ = $lead_id;
			$lead_id = ($lead_id + 0);

			$dbhA->query("SELECT list_id,phone_code from vicidial_list where lead_id='$lead_id'");
			if ($dbhA->has_selected_record)
			   {
				$iter=$dbhA->create_record_iterator;
				$rec_count=0;
				while ( $record = $iter->each)
					{
					$list_id =		 "$record->[0]";
					$phone_code =	 "$record->[1]";
					}
			   }
			if ($phone_code =~ /1144/)
				{
				if ($DB) {print "     $a sorting |$Xfilename|  wc:$word_count  file is UK: $lead_id    $list_id\n";}
				$country[$k] = 'UK';
				}
			else
				{
				if ($DB) {print "     $a sorting |$Xfilename|  wc:$word_count  file is US: $lead_id    $list_id\n";}
				$country[$k] = 'US';
				}

##### LET THE FILTERING BEGIN #####
	$not_sorted=1;	# set the match variable so a match does not happen after it has been matched
	$NEW_status='';
	$number =~ s/ 4/ FOUR/gi;		$number =~ s/4 /FOUR /gi;
	$number =~ s/ FOR/ FOUR/gi;  	$number =~ s/FOR /FOUR /gi;

	### IF ONE OR LESS WORDS ASSUME RINGING
	if ( ($not_sorted) && ($word_count < 2) )
		{$not_sorted=0;   $N++; $NEWstatus = 'N';   $NEWstatusP='N  ';   $DBstatus='N';   $ERRstatus='RING';}
	### LOTS of fours in a row assume busy
	if ( ($not_sorted) && ($number =~ /FOUR FOUR FOUR FOUR FOUR FOUR FOUR FOUR FOUR/) )
		{$not_sorted=0;   $B++; $NEWstatus = 'B';   $NEWstatusP='B  ';   $DBstatus='B';   $ERRstatus='BUSY';}
	### DISCONNECTED MESSAGE
	if ( ($not_sorted) && ($number =~ /DISCONNECTED/) )
		{$not_sorted=0;   $DC++; $NEWstatus = 'DC';   $NEWstatusP='DC ';   $DBstatus='DC';   $ERRstatus='DISCONNECTED';}
	### INVALID MESSAGE
	if ( ($not_sorted) && ($number =~ /INVALID/) )
		{$not_sorted=0;   $DCI++; $NEWstatus = 'DCI';   $NEWstatusP='DCI';   $DBstatus='DC';   $ERRstatus='INVALID';}
	### CHANGED MESSAGE
	if ( ($not_sorted) && ($number =~ /CHANGED|NEW NUMBER/) )
		{
		$not_sorted=0;   $DCC++; $NEWstatus = 'DCC';   $NEWstatusP='DCC';   $DBstatus='DC';   $ERRstatus='CHANGED';
		print Dout "$raw";
		`/usr/bin/cp -f $dir3/$Xfilename.* $dir3/CN/`;
		}
	### NOT IN SERVICE MESSAGE
	if ( ($not_sorted) && ($number =~ /IN SERVICE|NO LONGER|LONGER IN/) )
		{$not_sorted=0;   $DCN++; $NEWstatus = 'DCN';   $NEWstatusP='DCN';   $DBstatus='DC';   $ERRstatus='NOT IN SERVICE';}
	### DOES NOT ACCEPT INCOMING CALLS
	if ( ($not_sorted) && ($number =~ /INCOMING/) )
		{$not_sorted=0;   $DCIN++; $NEWstatus = 'DCIN';   $NEWstatusP='DCQ';   $DBstatus='DC';   $ERRstatus='NO INCOMING';}

	### LOTS of fours in a row assume busy
	if ( ($not_sorted) && ($word_count > 15) && ($number =~ /FOUR CALL|CALL FOUR/) )
		{$not_sorted=0;   $B++; $NEWstatus = 'B';   $NEWstatusP='B  ';   $DBstatus='B';   $ERRstatus='BUSY';}
	### LOTS of Os in a row assume busy
	if ( ($not_sorted) && ($word_count > 15) && ($number =~ /O O O O O O O O/) )
		{$not_sorted=0;   $B++; $NEWstatus = 'B';   $NEWstatusP='B  ';   $DBstatus='B';   $ERRstatus='BUSY';}
	### ASSUME RINGING
	if ( ($not_sorted) && ($word_count < 6) && ($number =~ /A A|FOUR FOUR/) )
		{$not_sorted=0;   $N++; $NEWstatus = 'N';   $NEWstatusP='N  ';   $DBstatus='N';   $ERRstatus='RING';}
	### DISCONNECTED MESSAGE
	if ( ($not_sorted) && ($number =~ /FURTHER|ADDITIONAL|RECORDING/) )
		{$not_sorted=0;   $DC++; $NEWstatus = 'DC';   $NEWstatusP='DC ';   $DBstatus='DC';   $ERRstatus='DISCONNECTED';}
	### INVALID MESSAGE
	if ( ($not_sorted) && ($number =~ /DIRECTORY/) )
		{$not_sorted=0;   $DCI++; $NEWstatus = 'DCI';   $NEWstatusP='DCI';   $DBstatus='DC';   $ERRstatus='INVALID';}
	### DISCONNECTED MESSAGE
	if ( ($not_sorted) && ($number =~ /RE SORRY|SORRY YOU/) )
		{$not_sorted=0;   $DCI++; $NEWstatus = 'DCI';   $NEWstatusP='DCI';   $DBstatus='DC';   $ERRstatus='INVALID';}
	### DISCONNECTED MESSAGE
	if ( ($not_sorted) && ($number =~ /NUMBER YOU|HAVE DIALED|HAVE REACHED/) )
		{$not_sorted=0;   $DC++; $NEWstatus = 'DC';   $NEWstatusP='DC ';   $DBstatus='DC';   $ERRstatus='INVALID';}
	### DISCONNECTED MESSAGE
	if ( ($not_sorted) && ($number =~ /REACHED AREA|AREA CODE|THE NUMBER|TEMPORARILY|CUSTOMER/) )
		{$not_sorted=0;   $DC++; $NEWstatus = 'DC';   $NEWstatusP='DC ';   $DBstatus='DC';   $ERRstatus='INVALID';}
	### DISCONNECTED MESSAGE
	if ( ($not_sorted) && ($word_count > 15) && ($number =~ /SORRY|DIALED|REACHED/) )
		{$not_sorted=0;   $DCI++; $NEWstatus = 'DCI';   $NEWstatusP='DCI';   $DBstatus='DC';   $ERRstatus='INVALID';}



		

	if (!$not_sorted)
		{
		$T_list='';
		if ($list_id_list !~ /$list_id\|/)
			{
			$list_id_list .= "$list_id|";
			$list_ary[$lqr] = "$list_id";
			$lqr++;
			}
		$A_list="T$list_id";
		$$A_list++;
		$T_list="$NEWstatus$list_id";
		$$T_list++;

		print "     LEAD SORTED:   $NEWstatusP $lead_id  $list_id\n";
		print Lout "$Xfilename!$lead_idZ!$list_id!$NEWstatusP!$ERRstatus!$number!\n";

		### update the vicidial_list entry for the lead
		$stmtA = "UPDATE vicidial_list set status='$DBstatus' where lead_id='$lead_id';";
		print Tout "$stmtA\n";
		$dbhA->query($stmtA);
		`/usr/bin/mv -f $dir3/$Xfilename.* $dir3/$DBstatus/`;
		}
	else
		{
		$O++;

		$T_list='';
		if ($list_id_list !~ /$list_id\|/)
			{
			$list_id_list .= "$list_id|";
			$list_ary[$lqr] = "$list_id";
			$lqr++;
			}
		$A_list="T$list_id";
		$$A_list++;
		$T_list="$NEWstatus$list_id";
		if (length($Tlist)>0) {$$T_list++;}

		print "     LEAD NOT SORTED:   O $lead_id  $list_id\n";
		print Lout "$Xfilename!$lead_idZ!$list_id!$NEWstatusP!NOT SORTED!$number!\n";
		print Rout "$raw";

		### update the vicidial_list entry for the lead
		$stmtA = "UPDATE vicidial_list set status='$DBstatus' where lead_id='$lead_id';";
		print Tout "$stmtA\n";
	#	$dbhA->query($stmtA);
		}



		$a++;

		if ($a =~ /0$/i) {print ".";}
		if ($a =~ /00$/i)
			{
			$secY = time();
			$secZ = ($secY - $secX);
			$secZm = ($secZ /60);  $secZm = sprintf("%.2f", $secZm);

			print "++++++++++ $a   N:$N  B:$B  DC:$DC  O:$O     $secZm\n";
			}

	}



print "RESULTS:\n";
print "STATUS            COUNT\n";
print "No Answer:        $N\n";
print "Busy:             $B\n";
print "Disconnected:     $DC\n";
print "Not In Service:   $DCN\n";
print "Changed Number:   $DCC\n";
print "Invalid:          $DCI\n";
print "No Incoming:      $DCIN\n";
print "Not Sorted:       $O\n";
print "\n";

$c=0;
foreach (@list_ary)
	{
	print "$list_ary[$c]\n";
	print "STATUS            COUNT\n";
	$T_list="N$list_ary[$c]";
	print "No Answer:        $$T_list\n";
	$T_list="B$list_ary[$c]";
	print "Busy:             $$T_list\n";
	$T_list="DC$list_ary[$c]";
	print "Disconnected:     $$T_list\n";
	$T_list="DCN$list_ary[$c]";
	print "Not In Service:   $$T_list\n";
	$T_list="DCC$list_ary[$c]";
	print "Changed Number:   $$T_list\n";
	$T_list="DCI$list_ary[$c]";
	print "Invalid:          $$T_list\n";
	$T_list="DCIN$list_ary[$c]";
	print "No Incoming:      $$T_list\n";
	$T_list="O$list_ary[$c]";
	print "Not Sorted:       $$T_list\n";
	$T_list="T$list_ary[$c]";
	print "TOTAL:            $$T_list\n";
	print "\n";

	$c++;
	}
print "DONE\n";

close(Lout);
close(Rout);
close(Tout);
close(Dout);

### calculate time to run script ###
$secY = time();
$secZ = ($secY - $secX);
$secZm = ($secZ /60);  $secZm = sprintf("%.2f", $secZm);

print "script execution time in seconds: $secZ     minutes: $secZm\n";

		`/usr/bin/mv -f $dir1/$FILEname $dir1/DONE/$FILEname`;

			}
		}
$i++;
   }


exit;

