#!/usr/bin/perl

#
# Copyright (C) 2006  Matt Florell <vicidial@gmail.com>    LICENSE: GPLv2
#

$US='_';
$txt='.txt';
## useage is ./sphinx2_pltest.pl <modeldir> <datadir> <toplevel> <ctlcount>
## test = ./sphinx2_pltest.pl 4426 /var/spool/asterisk/monitor/ORIG/VDAD/GO/USA/ 1 100000
## where modelname is the name of your expt and
##  datadir has some wav files to run over
## expect to run from the model directory
$model = shift;			# for telco error codes we use 4426
$datadir = shift;		# default /var/spool/asterisk/monitor/ORIG/VDAD/GO/USA/
$toplevel = shift;		# set to 4 for slow
$ctlcount = shift;		# utterances to be tried default to 100000

if ($toplevel < 0) {$toplevel=1;}
if ($toplevel > 4) {$toplevel=4;}

if ($ctlcount < 0) {$ctlcount=1;}
if ($ctlcount > 100000) {$ctlcount=100000;}

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year = ($year + 1900);
$mon++;
if ($mon < 10) {$mon = "0$mon";}
if ($mday < 10) {$mday = "0$mday";}
if ($hour < 10) {$hour = "0$hour";}
if ($min < 10) {$min = "0$min";}
if ($sec < 10) {$sec = "0$sec";}

$results_file = "VDAD_RESULTS_$year$mon$mday$US$hour$min$sec$txt";

$reportdir = '/home/cron/RESULTS';

#### old vars from original script from Australia
#$S2BATCH = "sphinx2-batch";
#$HMM = "model_parameters/$modelname.s2models";
#$LM = "/home/william/lm/8486.lm";
#$DICT = "etc/$modelname.dic";
#$NOISEDICT = "etc/$modelname.noisedic";
#$CTLFILE = "./task.ctl";



$S2BATCH = "/usr/local/bin/sphinx2-batch";
$HMM = "/usr/local/share/sphinx2/model/hmm/6k";
$LM = "/usr/local/share/sphinx2/model/lm/$model/$model.lm";
$DICT = "/usr/local/share/sphinx2/model/lm/$model/$model.dic";
#$NOISEDICT = "etc/$modelname.noisedic";  	 -noisedict ${NOISEDICT}
$CTLFILE = "/home/cron/task.ctl";

## get a list of wav files for the control file
open( CTL, ">$CTLFILE" ) || die "Can't open control file $CTLFILE";
$test_counter=0;
foreach $f (glob("$datadir/*.wav")) {
  $f =~ s/$datadir\///;
  $f =~ s/\.wav//;

  if ($test_counter < 10000)	###### set low for testing #####
	  {
	  print CTL "$f\n";
	  }
 $test_counter++;
}
close(CTL);

$command = "$S2BATCH  	 -verbose 2  	 -adcin TRUE  	 -adcext wav  	 -ctlfn ${CTLFILE}  	 -ctloffset 0  	 -ctlcount $ctlcount  	 -datadir $datadir  	 -agcmax TRUE  	 -langwt 6.5  	 -fwdflatlw 8.5  	 -rescorelw 9.5  	 -ugwt 0.5  	 -fillpen 1e-10  	 -silpen 0.005  	 -inspen 0.65  	 -top $toplevel  	 -topsenfrm 3  	 -topsenthresh -70000  	 -beam 2e-06  	 -npbeam 2e-06  	 -lpbeam 2e-05  	 -lponlybeam 0.0005  	 -nwbeam 0.0005  	 -fwdflat FALSE  	 -fwdflatbeam 1e-08  	 -fwdflatnwbeam 0.0003  	 -bestpath TRUE  	 -kbdumpdir $datadir  	 -lmfn ${LM}  	 -dictfn ${DICT}  	 -phnfn ${HMM}/phone  	 -mapfn ${HMM}/map  	 -hmmdir ${HMM}  	 -hmmdirlist ${HMM}  	 -8bsen TRUE  	 -sendumpfn ${HMM}/sendump  	 -cbdir ${HMM}  	 -matchfn $reportdir/$results_file";

system($command);

