#!/usr/bin/perl
#
# VDAD_dispo_NAs.pl version 0.1
#
# DESCRIPTION:
# Analyzes short audio recordings of pre-pickup calls(NA status) from VDAD
# and looks for patterns that are predefined within that file to try to dispo 
# that lead corectly for future use
#
# Copyright (C) 2006  Matt Florell <vicidial@gmail.com>    LICENSE: GPLv2
#

# constants
$DB=0;  # Debug flag, set to 0 for no debug messages, On an active system this will generate thousands of lines of output per minute
$US='__';
$MT[0]='';

$US = '_';
$secX = time();
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$year = ($year + 1900);
	$YYyear = ($year - 2000);
	if ($YYyear < 10) {$YYyear = "0$YYyear";}
	$mon++;
	if ($mon < 10) {$mon = "0$mon";}
	if ($mday < 10) {$mday = "0$mday";}
	if ($hour < 10) {$Fhour = "0$hour";}
	 else {$Fhour = $hour;}
	if ($min < 10) {$min = "0$min";}
	if ($sec < 10) {$sec = "0$sec";}
	$filedate = "$year$mon$mday$US$Fhour$min$sec";

### Make sure this file is in a libs path or put the absolute path to it
#require("/home/cron/AST_SERVER_conf.pl");	# local configuration file


use lib './lib', '../lib';
use Time::HiRes ('gettimeofday','usleep','sleep');  # necessary to have perl sleep command of less than one second
use Net::MySQL;
use Audio::Data;
#use Math::Complex;

### Make sure this file is in a libs path or put the absolute path to it
require("/home/cron/AST_SERVER_conf.pl");	# local configuration file

if (!$DB_port) {$DB_port='3306';}

my $dbhA = Net::MySQL->new(hostname => "$DB_server", database => "$DB_database", user => "$DB_user", password => "$DB_pass", port => "$DB_port") 
	or 	die "Couldn't connect to database: $DB_server - $DB_database\n";




 $i=0;
 $k=0;
 $dir1 = '/var/spool/asterisk/monitor/ORIG/VDAD/GO';
 #$dir1 = '/home/RECORDINGS/GSM/VDAD/USA/TEST';
 $dir2 = '/var/spool/asterisk/monitor/ORIG/VDAD/GO/USA';

 opendir(FILE, "$dir1/");
 @FILES = readdir(FILE);

foreach(@FILES)
   {

	if ($i < 1000000)	########## USED FOR TESTING ############
	{
	$size1 = 0;
	$size2 = 0;
	$person_id_delete = '';
	$transaction_id_delete = '';

	if (length($FILES[$i]) > 20)
		{
		$size1 = (-s "$dir1/$FILES[$i]");
#		if (!$q) {print "$FILES[$i] $size1\n";}
#		usleep(1*100*1000);	# sleep for tenth of a second
		$size2 = (-s "$dir1/$FILES[$i]");
#		if (!$q) {print "$FILES[$i] $size2\n\n";}

		if ( ($FILES[$i] !~ /au$/i) && ($size1 eq $size2) && ($FILES[$i] =~ /^V/))
#		if ( ($FILES[$i] !~ /gsm$/i) && ($size1 eq $size2) && ($FILES[$i] =~ /^V/))
			{
			$lead_id = '';
			$lead_id = $FILES[$i];
			if (length($lead_id) == 28) {$lead_id =~ s/-out.*$|V\d\d\d\d\d\d\d\d\d\d//gi;}
			  else {$lead_id =~ s/-out.*$|V\d\d\d\d\d\d\d\d\d//gi;}
			$lead_idsZ[$k] = $lead_id;
			$lead_id = ($lead_id + 0);

			$dbhA->query("SELECT list_id,phone_code from vicidial_list where lead_id='$lead_id'");
			if ($dbhA->has_selected_record)
			   {
				$iter=$dbhA->create_record_iterator;
				$rec_count=0;
				while ( $record = $iter->each)
					{
					$list_id =		 "$record->[0]";
					$phone_code =	 "$record->[1]";
					}
			   }
			if ($phone_code =~ /1144/)
				{
				if ($DB) {print "     file is UK: $lead_id    $list_id";}
				$country[$k] = 'UK';
				}
			else
				{
				if ($DB) {print "     file is US: $lead_id    $list_id";}
				$country[$k] = 'US';
				}

			if ($DB) {print "analyzing file: $lead_id   $FILES[$i]";}
			$list_ids[$k] = $list_id;
			$lead_ids[$k] = $lead_id;
			$files[$k] = $FILES[$i];
			$k++;
			}
		}

	if ($i =~ /0$/i) {print ".";}
	if ($i =~ /00$/i) {print "$i\n";}

	}
	$i++;
   }

$suf='.txt';
$Loutfile = "VDAD_LOG_$filedate$suf";
$Routfile = "VDAD_ERR_$filedate$suf";
### open the Log out file for writing ###
open(Lout, ">>/home/cron/LOGS/$Loutfile") || die "Can't open $Loutfile: $!\n";
open(Rout, ">>/home/cron/LOGS/$Routfile") || die "Can't open $Routfile: $!\n";




 



$i=0;
while($#files >= $i)
{
		$sizeGSM = (-s "$dir1/$files[$i]");

if ($i > 100000) {$i = '99999';}






############################################################################
############################################################################
##### PROCESS UK CALLS #####
############################################################################
############################################################################
if ($country[$i] =~ /UK/)
{
 $file = "$files[$i]";
 $GSMfilename = $file;
 $file =~ s/gsm$/au/gi;
 $filename = $file;
 $file = "$dir1/$file";

`/usr/bin/sox $dir1/$files[$i] -b -s -r 8000 $file silence 1 500 -45d`;
		$sizeAU = (-s "$file");

if ($sizeAU > 20000)
	{
	# print "FILE: $file - \n";
	 open(my $fh,"$file") || die "Cannot open $file:$!";
	 binmode($fh);
	 print "Loading $file";
	 my $au = Audio::Data->new(Load => $fh);
	 if ( ($au) && ($sizeAU > $sizeGSM) && ($sizeAU > 20000) )
	  {
		 @dcb=@MT; @dcbBG=@MT;
		 $max=0; $min=0; $j=0; $oz=0; $Smax=0; $lastS=0;
		 $amp10=0; $amp100=0; $ampXX=0; $ampAV=0; $ampOZ=0;
		 $Scount=0; $Sreset=0; @Slength=@MT; $Sct=0;

	   $dur		= $au->duration;
	   $samp	= $au->samples;
	   $rate	= $au->rate;
	   @dcbBG	= $au->amplitude(0,10);
	   @dcb		= $au->amplitude(16000,96000); # grab amplitude on 10 seconds of audio starting after the 2nd second
	#   @dcbBG	= $au->dB(0,10);
	#   @dcb		= $au->dB(16000,80000);
	#   $freq	= $au->fft($FFT_SIZE);
	#   $time	= $freq->ifft($FFT_SIZE);
	#   print "     length: $dur     samples: $samp     rate: $rate\n";
			$j=0;
		foreach(@dcb)
		   {
			  $dcb[$j] = sprintf("%.0f", ($dcb[$j] * 100000));
			  $v = abs($dcb[$j]);
			$max = $v if $v > $max;
			$min = $v if $v < $min;

			if ($v > 5) 
				{
				$ampOZ = ($ampOZ + $v);
				$ampXX = ($ampXX + $v);
				$oz++;
				}
			if ($v < 1750) # last set at 1500
			   {
				if ($lastS)
					{
					$Smax = $lastS if $lastS > $Smax;
					if ($lastS > 200) #last set at 100
						{
						$Slength[$Sct] = $lastS;
						$Sreset++;					
						}
					}
				$lastS++;
			   }
			else
			   {
				$lastS=0;
				if ($Sreset) {$Sct++;   $Sreset=0;}
			   }

			if ($j =~ /0$/i) 
				{
				$amp10 = ($amp10 + $v);
				}
			$j++;
		   }

		if ( (!$j) or (!$oz) )
			{
			$not_sorted=0; 
			$VDAD_S[$N]="$lead_ids[$i]"; 
			$S++;  $gS++;
			$NEWstatus = 'S';   $NEWstatusP='S  ';   $DBstatus='NA';
			}
		else
		  {
		   $ampAV = ($ampXX / $j);
		   $ampAV = sprintf("%.0f", $ampAV);
		   $amp10AV = ($amp10 / ($j / 10));
		   $amp10AV = sprintf("%.0f", $amp10AV);
		   $ampOZAV = ($ampOZ / $oz);
		   $ampOZAV = sprintf("%.0f", $ampOZAV);
		  }
	#   print "     Max Db: $max\n";
	#   print "     Min Db: $min\n";
	#   print "     Max Silence: $Smax\n";
		$m=0;
	#   foreach (@Slength) {print "$Slength[$m]|";   $m++;}
	#   print "     END SILENCE COUNTS\n";
	#   print "     start Db:       $dcbBG[0]\n";
	#   print "     total Db:       $ampXX\n";
	#   print "     average Db:     $ampAV   ($ampXX / $j)\n";
	#   print "     10s total Db:   $amp10\n";
	#   print "     10s average Db: $amp10AV   ($ampOZ / $oz)\n";
	#   print "     OZ total Db:    $ampOZ     OZ average Db:  $ampOZAV   ($ampOZ / $oz)\n";

	   ### sort each sound file into a category ###
	   $not_sorted=1;
	 ########## FIRST PASS TESTS - based on silence timings ##########
	  ### SILENCE ### (less than two silence gaps or gap stops)
	   if ( ($not_sorted) && ($#Slength < 3) )
		{
		$not_sorted=0; 
		$VDAD_S[$N]="$lead_ids[$i]"; 
		$S++;  $gS++;
		$NEWstatus = 'S';   $NEWstatusP='S  ';   $DBstatus='NA';
		}
	  ### SILENCE GAPS TESTS ### (try to categorize calls by silence gaps patterns)
	   if ( ($not_sorted) && ($#Slength > 2) )
		{
			$m=0; $pattern_match=0;
		  ### NO ANSWER gap test ###
			foreach (@Slength) 
				{
				if ( ($Slength[$m] > 14000) && ($Slength[$m] < 17000) && ($Slength[($m+1)] > 1400) && ($Slength[($m+1)] < 1650) && ($Slength[($m+2)] > 14000) && ($Slength[($m+2)] < 17000) && ($Slength[($m+3)] > 1400) && ($Slength[($m+3)] < 1650) )
					{
					$not_sorted=0; 
					$VDAD_N[$N]="$lead_ids[$i]"; 
					$NEWstatus = 'N';   $NEWstatusP='N  ';   $DBstatus='N';
					}
				$m++;
				}
			if ( (!$not_sorted) && ($NEWstatus == 'N') ) {$N++;   $gN++;}

			if ($not_sorted)
			{
			$m=0; $pattern_match=0;
			### BUSY gap test ###
			foreach (@Slength) 
				{
				if ( ($Slength[$m] > 3800) && ($Slength[$m] < 4100) && ($Slength[($m+1)] > 3800) && ($Slength[($m+1)] < 4100) && ($Slength[($m+2)] > 3800) && ($Slength[($m+2)] < 4100) && ($Slength[($m+3)] > 3800) && ($Slength[($m+3)] < 4100) )
					{
					$not_sorted=0; 
					$VDAD_B[$B]="$lead_ids[$i]"; 
					$NEWstatus = 'B';   $NEWstatusP='B  ';   $DBstatus='B';
					}
				$m++;
				}
			if ( (!$not_sorted) && ($NEWstatus == 'B') ) {$B++;   $gB++;}
			}

			if ($not_sorted)
			{
			$m=0; $pattern_match=0;
			### FAST BUSY gap test ###
			foreach (@Slength) 
				{
				if ( ($Slength[$m] > 1525) && ($Slength[$m] < 1625) && ($Slength[($m+1)] > 1525) && ($Slength[($m+1)] < 1625) && ($Slength[($m+2)] > 1525) && ($Slength[($m+2)] < 1625) && ($Slength[($m+3)] > 1525) && ($Slength[($m+3)] < 1625) )
					{
					$not_sorted=0; 
					$VDAD_FB[$FB]="$lead_ids[$i]"; 
					$NEWstatus = 'FB';   $NEWstatusP='FB ';   $DBstatus='DC';
					}
				$m++;
				}
			if ( (!$not_sorted) && ($NEWstatus == 'FB') ) {$FB++;   $gFB++;}
			}

			if ($not_sorted)
			{
			$m=0; $pattern_match=0;
			### FAST BUSY 2 gap test ###
			foreach (@Slength) 
				{
				if ( ($Slength[$m] > 1925) && ($Slength[$m] < 2100) && ($Slength[($m+1)] > 1925) && ($Slength[($m+1)] < 2100) && ($Slength[($m+2)] > 1925) && ($Slength[($m+2)] < 2100) && ($Slength[($m+3)] > 1925) && ($Slength[($m+3)] < 2100) )
					{
					$not_sorted=0; 
					$VDAD_FB2[$FB2]="$lead_ids[$i]"; 
					$NEWstatus = 'FB2';   $NEWstatusP='FB2';   $DBstatus='DC';
					}
				$m++;
				}
			if ( (!$not_sorted) && ($NEWstatus == 'FB2') ) {$FB2++;   $gFB2++;}
			}



		}



	 ########## SECOND PASS TESTS - less accurate ##########
	  ### NO ANSWER ###
	   if ( ($not_sorted) && ($ampOZAV > 6000) && ($#Slength < 12) && ($Smax > 10000) )
		{
		$not_sorted=0; 
		$VDAD_N[$N]="$lead_ids[$i]"; 
		$N++; 
		$NEWstatus = 'N';   $NEWstatusP='N  ';   $DBstatus='N';
		}

	  ### NO ANSWER with telco message ###
	   if ( ($not_sorted) && ($ampOZAV > 8000) && ($#Slength < 25) && ($Smax > 10000) )
		{
		$not_sorted=0; 
		$VDAD_N2[$N2]="$lead_ids[$i]"; 
		$N2++; 
		$NEWstatus = 'N2';   $NEWstatusP='N2 ';   $DBstatus='N';
		}

	  ### BUSY ###
	   if ( ($not_sorted) && ($ampOZAV > 1920) && ($ampOZAV < 2550) && ($#Slength < 16) && ($Smax > 3850) && ($Smax < 4100) )
		{
		$not_sorted=0; 
		$VDAD_B[$B]="$lead_ids[$i]"; 
		$B++; 
		$NEWstatus = 'B';   $NEWstatusP='B  ';   $DBstatus='B';
		}

	  ### FAST BUSY ###
	   if ( ($not_sorted) && ($ampOZAV > 2500) && ($ampOZAV < 3250) && ($#Slength < 28) && ($Smax > 1550) && ($Smax < 2100) )
		{
		$not_sorted=0; 
		$VDAD_FB[$FB]="$lead_ids[$i]"; 
		$FB++; 
		$NEWstatus = 'FB';   $NEWstatusP='FB ';   $DBstatus='DC';
		}

	  ### NOT IN SERVICE ###
	   if ( ($not_sorted) && ($ampOZAV > 1500) && ($ampOZAV < 3550) && ($#Slength < 50) && ($Smax > 10000) && ($Smax < 40000) )
		{
		$not_sorted=0; 
		$VDAD_DC[$DC]="$lead_ids[$i]"; 
		$DC++; 
		$NEWstatus = 'DC';   $NEWstatusP='DC ';   $DBstatus='DC';
		}

	  ### INVALID ###
	   if ( ($not_sorted) && ($ampOZAV > 3500) && ($ampOZAV < 3900) && ($#Slength < 50) && ($#Slength > 24) && ($Smax > 9300) && ($Smax < 15000) )
		{
		$not_sorted=0; 
		$VDAD_INV[$INV]="$lead_ids[$i]"; 
		$INV++; 
		$NEWstatus = 'INV';   $NEWstatusP='INV';   $DBstatus='DC';
		}

	  ### IF ALL ELSE FAILED TRY THESE PATTERN MATCHES ###
		if ($not_sorted)
		{
		$m=0; $pattern_match=0;
		### NO ANSWER 2 gap test ###
		foreach (@Slength) 
			{
			if (
				( 
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+4)] > 14000) && ($Slength[($m+4)] < 17000) && 
				 ($Slength[($m+8)] > 14000) && ($Slength[($m+8)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+4)] > 14000) && ($Slength[($m+4)] < 17000) && 
				 ($Slength[($m+7)] > 14000) && ($Slength[($m+7)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+3)] > 14000) && ($Slength[($m+3)] < 17000) && 
				 ($Slength[($m+7)] > 14000) && ($Slength[($m+7)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+3)] > 14000) && ($Slength[($m+3)] < 17000) && 
				 ($Slength[($m+6)] > 14000) && ($Slength[($m+6)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+3)] > 14000) && ($Slength[($m+3)] < 17000) && 
				 ($Slength[($m+5)] > 14000) && ($Slength[($m+5)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+2)] > 14000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+6)] > 14000) && ($Slength[($m+6)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+2)] > 14000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+5)] > 14000) && ($Slength[($m+5)] < 17000)
				) or (
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+2)] > 14000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+4)] > 14000) && ($Slength[($m+4)] < 17000)
				)
			   )
				{
				$not_sorted=0; 
				$VDAD_N[$N]="$lead_ids[$i]"; 
				$NEWstatus = 'N';   $NEWstatusP='N  ';   $DBstatus='N';
				}
			$m++;
			}
		if ( (!$not_sorted) && ($NEWstatus == 'N') ) {$N++;   $g2N++;}
		}

		if ($not_sorted)
		{
		$m=0; $pattern_match=0;
		### NO ANSWER 3 gap test ###
		foreach (@Slength) 
			{
			if (
				( 
				 ($Slength[$m] >     14000) && ($Slength[$m] <     17000) && 
				 ($Slength[($m+1)] > 1400)  && ($Slength[($m+1)] < 1650) && 
				 ($Slength[($m+2)] > 14000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+3)] > 1400)  && ($Slength[($m+3)] < 1650)
				) or ( 
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+4)] > 10000) && ($Slength[($m+4)] < 17000) && 
				 ($Slength[($m+8)] > 10000) && ($Slength[($m+8)] < 17000)
				) or ( 
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+5)] > 10000) && ($Slength[($m+5)] < 17000) && 
				 ($Slength[($m+10)] > 10000) && ($Slength[($m+10)] < 17000)
				) or ( 
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+5)] > 10000) && ($Slength[($m+5)] < 17000) && 
				 ($Slength[($m+9)] > 10000) && ($Slength[($m+9)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+4)] > 10000) && ($Slength[($m+4)] < 17000) && 
				 ($Slength[($m+7)] > 10000) && ($Slength[($m+7)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+3)] > 10000) && ($Slength[($m+3)] < 17000) && 
				 ($Slength[($m+7)] > 10000) && ($Slength[($m+7)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+3)] > 10000) && ($Slength[($m+3)] < 17000) && 
				 ($Slength[($m+6)] > 10000) && ($Slength[($m+6)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+3)] > 10000) && ($Slength[($m+3)] < 17000) && 
				 ($Slength[($m+5)] > 10000) && ($Slength[($m+5)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+2)] > 10000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+6)] > 10000) && ($Slength[($m+6)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+2)] > 10000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+5)] > 10000) && ($Slength[($m+5)] < 17000)
				) or (
				 ($Slength[$m] >     10000) && ($Slength[$m] <     17000) &&
				 ($Slength[($m+2)] > 10000) && ($Slength[($m+2)] < 17000) && 
				 ($Slength[($m+4)] > 10000) && ($Slength[($m+4)] < 17000)
				)

			   )
				{
				$not_sorted=0; 
				$VDAD_N[$N]="$lead_ids[$i]"; 
				$NEWstatus = 'N';   $NEWstatusP='N  ';   $DBstatus='N';
				}
			$m++;
			}
		if ( (!$not_sorted) && ($NEWstatus == 'N') ) {$N++;   $g3N++;}
		}

		if ($not_sorted)
		{
		$m=0; $pattern_match=0;
		### UK CHANGED NUMBER gap test ###
		foreach (@Slength) 
			{
			if (
				( 
				 ($Smax < 12000) && ($ampOZAV > 3000) && ($ampOZAV < 10000) &&
				 ($#Slength > 15) && 
				 ($Slength[$m] >     1000) && ($Slength[$m] <     10000) &&
				 ($Slength[($m+1)] > 1000) && ($Slength[($m+1)] < 10000) && 
				 ($Slength[($m+2)] > 1000) && ($Slength[($m+2)] < 10000) && 
				 ($Slength[($m+3)] > 1000) && ($Slength[($m+3)] < 10000)
				)
			   )
				{
				$not_sorted=0; 
				$VDAD_CN[$CN]="$lead_ids[$i]"; 
				$NEWstatus = 'CN';   $NEWstatusP='CN ';   $DBstatus='DC';
				}
			$m++;
			}
		if ( (!$not_sorted) && ($NEWstatus == 'CN') ) {$CN++;   $gCN++;}
		}



	  ### OTHER ###
	   if ($not_sorted)
		   {
			$T_list='';
			if ($list_id_list !~ /$list_ids[$i]\|/)
				{
				$list_id_list .= "$list_ids[$i]|";
				$list_ary[$lqr] = "$list_ids[$i]";
				$lqr++;
				}
			$A_list="T$list_ids[$i]";
			$$A_list++;
			$T_list="O$list_ids[$i]";
			$$T_list++;

			$VDAD_O[$O]="$lead_ids[$i]"; $O++;
		   print "UK LEAD NOT SORTED!!! $lead_ids[$i] |Max Silence: $Smax|\n";
		   print "  length: $dur     samples: $samp     rate: $rate\n   ";
		   $m=0;
		   foreach (@Slength) {print "$Slength[$m]|";   $m++;}
		   print "\n";
		   print "  OZ total Db:    $ampOZ     OZ average Db:  $ampOZAV   ($ampOZ / $oz)\n\n";
			print Lout "UK!$filename!$lead_idsZ[$i]!$list_ids[$i]!O  !$dur!$samp!$rate!$Smax!$ampOZ!$ampOZAV!$oz!$#Slength!";
				$m=0;
			foreach (@Slength) {print Lout "$Slength[$m]|";   $m++;}
			print Lout "!\n";

			print Rout "UK!$filename!$lead_idsZ[$i]!$list_ids[$i]!O  !$dur!$samp!$rate!$Smax!$ampOZ!$ampOZAV!$oz!$#Slength!";
				$m=0;
			foreach (@Slength) {print Rout "$Slength[$m]|";   $m++;}
			print Rout "!\n";
			`/usr/bin/mv -f $dir1/$GSMfilename $dir1/UK/O/$GSMfilename`;
			`/usr/bin/rm -f $dir1/$filename`;
		   }
		else
			{
			$T_list='';
			if ($list_id_list !~ /$list_ids[$i]\|/)
				{
				$list_id_list .= "$list_ids[$i]|";
				$list_ary[$lqr] = "$list_ids[$i]";
				$lqr++;
				}
			$A_list="T$list_ids[$i]";
			$$A_list++;
			$T_list="$NEWstatus$list_ids[$i]";
			$$T_list++;

			print "     UK LEAD SORTED:   $NEWstatusP $lead_ids[$i]  $list_ids[$i]\n";
			print Lout "UK!$filename!$lead_idsZ[$i]!$list_ids[$i]!$NEWstatusP!$dur!$samp!$rate!$Smax!$ampOZ!$ampOZAV!$oz!$#Slength!";

			### update the vicidial_list entry for the lead
			$stmtA = "UPDATE vicidial_list set status='$DBstatus' where lead_id='$lead_ids[$i]';";
			$dbhA->query($stmtA);

				$m=0;
			foreach (@Slength) {print Lout "$Slength[$m]|";   $m++;}
			print Lout "!\n";
			`/usr/bin/mv -f $dir1/$GSMfilename $dir1/UK/$NEWstatus/$GSMfilename`;
			`/usr/bin/rm -f $dir1/$filename`;
			}

	#   print "\n";
	  }
	else	### SILENCE FILE ###
	  {
		$T_list='';
		if ($list_id_list !~ /$list_ids[$i]\|/)
			{
			$list_id_list .= "$list_ids[$i]|";
			$list_ary[$lqr] = "$list_ids[$i]";
			$lqr++;
			}
		$A_list="T$list_ids[$i]";
		$$A_list++;
		$T_list="S$list_ids[$i]";
		$$T_list++;

		$VDAD_S[$DC]="$lead_ids[$i]"; 
		$S++; 
		print "     UK LEAD SORTED:   S  $lead_ids[$i]\n";
		print Lout "UK!$filename!$lead_idsZ[$i]!S  !!!!!!!!!!\n";
		`/usr/bin/mv -f $dir1/$GSMfilename $dir1/UK/S/$GSMfilename`;
		`/usr/bin/rm -f $dir1/$filename`;
	  }

	 close($fh);
	}	### END SIZE AU > 20000 Bytes
else
	{
	print "     UK CONVERSION BAD DELETING\n";
	`/usr/bin/rm -f $file`;
	`/usr/bin/rm -f $dir1/$files[$i]`;

	}

}	### END UK ANALYSIS












############################################################################
############################################################################
##### PROCESS USA CALLS #####
############################################################################
############################################################################
if ($country[$i] =~ /US/)
{
 $file = "$files[$i]";
 $GSMfilename = $file;
 $file =~ s/gsm$/wav/gi;
 $filename = $file;
 $file = "$dir2/$file";
	chomp($file);
	$stat = 'stat';
$normalize = `/usr/bin/sox -t gsm -b $dir1/$files[$i] -e $stat -v  2>&1`;
	chomp($normalize);

	 print "Copying $dir1/$files[$i] $file |$normalize|\n";

`/usr/bin/sox -t gsm -b $dir1/$files[$i] -w -s -r 16000 -v $normalize $file silence 1 500 -45d`;
		$sizeWAV = (-s "$file");

	 print "DONE |$file|     |$sizeWAV|\n";

	`/usr/bin/rm -f $dir1/$files[$i]`;

}	### END USA ANALYSIS











$i++;
	if ($i =~ /0$/i) 
		{
		$secY = time();
		$secZ = ($secY - $secX);
		$secZm = ($secZ /60);  $secZm = sprintf("%.2f", $secZm);

		print "++++++++++ $i   N:$N  N2:$N2  B:$B  FB:$FB  FB2:$FB2  DC:$DC  INV:$INV  CN:$CN  S:$S  O:$O     $secZm\n";
		}

}

print "RESULTS:\n";
print "STATUS            COUNT      GAP   2nd   3rd\n";
print "No Answer:        $N         $gN   $g2N   $g3N\n";
print "No Answer (annc): $N2         $gN2\n";
print "Busy:             $B         $gB\n";
print "Fast Busy:        $FB         $gFB\n";
print "Fast Busy 2:      $FB2         $gFB2\n";
print "Not In Service:   $DC         $gDC\n";
print "Not In Service:   $INV         $gINV\n";
print "Changed Number:   $CN         $gCN\n";
print "Silence:          $S         $gS\n";
print "Other:            $O\n";
print "\n\n";

$c=0;
foreach (@list_ary)
	{
	print "STATS CHANGED FOR LIST: $list_ary[$c]:\n";
	print "STATUS            COUNT\n";
	$T_list="N$list_ary[$c]";
	print "No Answer:        $$T_list\n";
	$T_list="N2$list_ary[$c]";
	print "No Answer (annc): $$T_list\n";
	$T_list="B$list_ary[$c]";
	print "Busy:             $$T_list\n";
	$T_list="FB$list_ary[$c]";
	print "Fast Busy:        $$T_list\n";
	$T_list="FB2$list_ary[$c]";
	print "Fast Busy 2:      $$T_list\n";
	$T_list="DC$list_ary[$c]";
	print "Not In Service:   $$T_list\n";
	$T_list="INV$list_ary[$c]";
	print "Invalid Number:   $$T_list\n";
	$T_list="CN$list_ary[$c]";
	print "Changed Number:   $$T_list\n";
	$T_list="S$list_ary[$c]";
	print "Silence:          $$T_list\n";
	$T_list="O$list_ary[$c]";
	print "Other:            $$T_list\n";
	$T_list="T$list_ary[$c]";
	print "TOTAL:            $$T_list\n";

	$c++;
	}
print "DONE\n";

close(Lout);
close(Rout);

### calculate time to run script ###
$secY = time();
$secZ = ($secY - $secX);
$secZm = ($secZ /60);  $secZm = sprintf("%.2f", $secZm);

print "script execution time in seconds: $secZ     minutes: $secZm\n";

exit;













	my $dbhA = Net::MySQL->new(hostname => "$DB_server", database => "$DB_database", user => "$DB_user", password => "$DB_pass") 
	or 	die "Couldn't connect to database: \n";


@PTextensions=@MT; @PTvoicemail_ids=@MT; @PTmessages=@MT; @PTold_messages=@MT; @NEW_messages=@MT; @OLD_messages=@MT;
$dbhA->query("SELECT extension,voicemail_id,messages,old_messages from phones where server_ip='$server_ip'");
if ($dbhA->has_selected_record)
   {
	$iter=$dbhA->create_record_iterator;
	$rec_count=0;
	while ( $record = $iter->each)
		{
		$PTextensions[$rec_count] =		 "$record->[0]";
		$PTvoicemail_ids[$rec_count] =	 "$record->[1]";
		$PTmessages[$rec_count] =		 "$record->[2]";
		$PTold_messages[$rec_count] =	 "$record->[3]";
		$rec_count++;
		}
   }


### connect to asterisk manager through telnet
$t = new Net::Telnet (Port => 5038,
					  Prompt => '/.*[\$%#>] $/',
					  Output_record_separator => '',);
#$fh = $t->dump_log("$telnetlog");  # uncomment for telnet log
$t->open("$telnet_host"); 
$t->waitfor('/0\n$/');			# print login
$t->print("Action: Login\nUsername: $ASTmgrUSERNAME\nSecret: $ASTmgrSECRET\n\n");
$t->waitfor('/Authentication accepted/');		# waitfor auth accepted


$i=0;
foreach(@PTextensions)
	{
	@list_channels=@MT;
	$t->buffer_empty;
	@list_channels = $t->cmd(String => "Action: MailboxCount\nMailbox: $PTvoicemail_ids[$i]\n\nAction: Ping\n\n", Prompt => '/Response: Pong.*/'); 

	$j=0;
	foreach(@list_channels)
		{
		if ($list_channels[$j] =~ /Mailbox: $PTvoicemail_ids[$i]/)
			{
			$NEW_messages[$i] = "$list_channels[$j+1]";
			$NEW_messages[$i] =~ s/NewMessages: |\n//gi;
			$OLD_messages[$i] = "$list_channels[$j+2]";
			$OLD_messages[$i] =~ s/OldMessages: |\n//gi;
			}

		$j++;
		}

	if($DB){print "MailboxCount- NEW:|$NEW_messages[$i]|  OLD:|$OLD_messages[$i]|\n";}
	if ( ($NEW_messages[$i] eq $PTmessages[$i]) && ($OLD_messages[$i] eq $PTold_messages[$i]) )
		{
		if($DB){print "MESSAGE COUNT UNCHANGED, DOING NOTHING FOR THIS MAILBOX\n";}
		}
	else
		{
		$stmtA = "UPDATE phones set messages='$NEW_messages[$i]', old_messages='$OLD_messages[$i]' where server_ip='$server_ip' and extension='$PTextensions[$i]'";
			if($DB){print STDERR "\n|$stmtA|\n";}
		$dbhA->query($stmtA)  or die  "Couldn't execute query:\n";
		}

	$i++;
		### sleep for 10 hundredths of a second
		usleep(1*100*1000);
	}


$t->buffer_empty;
@hangup = $t->cmd(String => "Action: Logoff\n\n", Prompt => "/.*/"); 
$t->buffer_empty;
$ok = $t->close;

$dbhA->close;

if($DB){print "DONE... Exiting... Goodbye... See you later... Really I mean it this time\n";}

### calculate time to run script ###
$secY = time();
$secZ = ($secY - $secX);
$secZm = ($secZ /60);  $secZm = sprintf("%.2f", $secZm);

print "script execution time in seconds: $secZ     minutes: $secZm\n";

exit;




